import hou
import PySide2.QtWidgets
import PySide2.QtCore



class SDK(PySide2.QtWidgets.QMainWindow):
    def __init__(self, ):

        self.author = 'VS 666'
        self.version = '1.2.0'

        super().__init__(hou.qt.mainWindow())

        self.setWindowTitle('Set Driven Key v({})'.format(self.version))
        import tkinter as tk
        root = tk.Tk()
        # Get the screen width and height
        screen_width = root.winfo_screenwidth()
        screen_height = root.winfo_screenheight()
        self.resize(screen_width*23/100, screen_height*32/100)
        self.setMinimumWidth(screen_width*23/100)
        self.setMinimumHeight(screen_height*32/100)

        mainWidget = PySide2.QtWidgets.QWidget()
        self.setCentralWidget(mainWidget)

        layout = PySide2.QtWidgets.QVBoxLayout()
        mainWidget.setLayout(layout)


        # Buttons layout
        buttons_layout = PySide2.QtWidgets.QHBoxLayout()
        
        # Confirm button
        loadDriver_button = PySide2.QtWidgets.QPushButton('Load Driver')
        loadDriver_button.clicked.connect(self.loadDriver)

        buttons_layout.addWidget(loadDriver_button)
        
        # Cancel button
        loadDriven_button = PySide2.QtWidgets.QPushButton('Load Driven')
        loadDriven_button.clicked.connect(self.loadDriven)
        buttons_layout.addWidget(loadDriven_button)
        
        layout.addLayout(buttons_layout)


        #List layout
        list_layout = PySide2.QtWidgets.QHBoxLayout()
        #Driver list
        self.driverList_widget = PySide2.QtWidgets.QListWidget()
        self.driverList_widget.setSelectionMode(PySide2.QtWidgets.QListWidget.SingleSelection) 
        list_layout.addWidget(self.driverList_widget)

        #Driven list
        self.drivenList_widget = PySide2.QtWidgets.QListWidget()
        self.drivenList_widget.setSelectionMode(PySide2.QtWidgets.QListWidget.SingleSelection) 
        list_layout.addWidget(self.drivenList_widget)

        layout.addLayout(list_layout)




        # Buttons layout
        buttons_layout = PySide2.QtWidgets.QHBoxLayout()
        
        # sekKey_button button
        sekKey_button = PySide2.QtWidgets.QPushButton('Set Key')
        sekKey_button.clicked.connect(self.sekKey)

        buttons_layout.addWidget(sekKey_button)
        
        # toggle button
        toggle_button = PySide2.QtWidgets.QPushButton('Toggle Expression')
        toggle_button.clicked.connect(self.toggle)
        buttons_layout.addWidget(toggle_button)
        
        layout.addLayout(buttons_layout)

        self.driver = None
        self.driven = None


        sel = hou.selectedNodes()
        if len(sel) > 0:
            self.loadDriver()


    def loadDriver(self):
        selectedObjs = hou.selectedNodes()
        if len(selectedObjs) > 0:
            selectedObj = selectedObjs[0]
            self.driver = selectedObj
            scoped = []
            for parms in selectedObj.parms():
                if parms.isAutoscoped():
                    if parms.name().startswith("SDK"):
                        pass
                    else:
                        scoped.append(selectedObj.path() + "/" + parms.name())

            self.driverList_widget.clear()
            self.populate_list_widget(scoped, self.driverList_widget)
        else:
            self.driverList_widget.clear()
            self.driver = None


    def loadDriven(self):
        selectedObjs = hou.selectedNodes()
        if len(selectedObjs) > 0:
            selectedObj = selectedObjs[0]
            self.driven = selectedObj
            scoped = []
            for parms in selectedObj.parms():
                if parms.isAutoscoped():
                    if parms.name().startswith("SDK"):
                        pass
                    else:
                        scoped.append(selectedObj.path() + "/" + parms.name())

            self.populate_list_widget(scoped, self.drivenList_widget)
        else:
            self.drivenList_widget.clear()
            self.driven = None


    def populate_list_widget(self, parms, widget):
        widget.clear()

        for param in parms:
            item = PySide2.QtWidgets.QListWidgetItem(param)
            #item.setFlags(item.flags() | PySide2.QtCore.ItemIsSelectable)  # Only selectable, not editable
            widget.addItem(item)



    def sekKey(self):
        if self.driver and self.driven:
            if self.driverList_widget.currentItem() and self.drivenList_widget.currentItem():
                self.driverParm = hou.parm(self.driverList_widget.currentItem().text())
                self.drivenParm = hou.parm(self.drivenList_widget.currentItem().text())

                self.driverFloatParm = hou.FloatParmTemplate("SDK_"+self.driver.name()+self.driverParm.name().split()[-1]+"_"+self.driven.name()+self.drivenParm.name().split()[-1], "", 1)

                if self.driven.parm(self.driverFloatParm.name()):
                    pass
                else:
                    self.driven.addSpareParmTuple(self.driverFloatParm, ("SDK", ),  True)

                sdk_parm = hou.parm(self.driven.path()+"/"+self.driverFloatParm.name())
                sdk_parm.setAutoscope(True)
                key = hou.Keyframe(self.drivenParm.eval(), (self.driverParm.eval()-1)/24)
                key.setExpression("linear()", hou.exprLanguage.Hscript)
                sdk_parm.setKeyframe(key)

                



                
            

    def toggle(self):
    
        self.driverParm = hou.parm(self.driverList_widget.currentItem().text())
        self.drivenParm = hou.parm(self.drivenList_widget.currentItem().text())

        drindex = self.driverParm.path().rfind('/')
        dnindex = self.drivenParm.path().rfind('/')

        self.driver = hou.node(self.driverParm.path()[:drindex])
        self.driven = hou.node(self.drivenParm.path()[:dnindex])

        self.driverFloatParm = hou.FloatParmTemplate("SDK_"+self.driver.name()+self.driverParm.name().split()[-1]+"_"+self.driven.name()+self.drivenParm.name().split()[-1], "", 1)

        try:
            self.drivenParm.expression()
            self.drivenParm.deleteAllKeyframes()
        except:
            if hou.parm(self.driven.path() +"/"+self.driverFloatParm.name()):
                self.drivenParm.setExpression("chf('{}', ch('{}'))".format(self.driverFloatParm.name(), self.driverParm.path()))




def run():
    global SDK_tool
    # Create instance of the RenamerTool window

    try:
        SDK_tool.close()
    except:
        pass

    SDK_tool = SDK()
    SDK_tool.show()
    return SDK_tool