import nuke
from PySide2.QtWidgets import QApplication, QWidget, QVBoxLayout, QPushButton, QListWidget, QDialog, QCheckBox
import os
import json
import shutil
import compControls.main



def show_list_ui():
    # Create the application (Nuke is already running an event loop, so we need to use this carefully)
    app = QApplication.instance()  # Get the existing QApplication instance
    if app is None:
        app = QApplication([])  # Create a new one if not already created

    # Create the dialog window
    dialog = QDialog()
    dialog.setWindowTitle("Select project to remove")

    # Layout for the dialog
    layout = QVBoxLayout(dialog)

    # Create the QListWidget with some options
    list_widget = QListWidget()
    items = list(read_json().keys())
    list_widget.addItems(items)
    list_widget.setSelectionMode(QListWidget.SingleSelection)  # Only allow one item to be selected

    layout.addWidget(list_widget)

    delete_checkbox = QCheckBox("Delete project permanently")
    delete_checkbox.setChecked(True)  # Set the checkbox to be checked by default
    layout.addWidget(delete_checkbox)

    # OK button to confirm selection
    ok_button = QPushButton("OK")
    layout.addWidget(ok_button)

    # Function to handle the OK button click
    def on_ok_clicked():
        selected_items = list_widget.selectedItems()
        if selected_items:
            selected_item = selected_items[0].text()
            file_path = os.path.join(os.path.join(os.path.join(os.path.expanduser("~"), ".nuke"), "vs666", "data"), "compControls.json")
            with open(file_path, 'r') as file:
                data = json.load(file)

            if delete_checkbox.isChecked():
                path = data[selected_item]["path"]
                folder_path = os.path.join(path, selected_item)
                if os.path.exists(folder_path):
                    shutil.rmtree(folder_path)

            del data[selected_item]

            with open(file_path, 'w') as file:
                json.dump(data, file, indent=4)

            if delete_checkbox.isChecked():
                pass

        compControls.main.refresh()
        dialog.accept()


    ok_button.clicked.connect(on_ok_clicked)

    # Show the dialog
    dialog.setLayout(layout)
    dialog.exec_()  # This is a blocking call, it will wait until the dialog is closed


def read_json():
    try:
        with open(os.path.join(os.path.join(os.path.join(os.path.expanduser("~"), ".nuke"), "vs666", "data"), "compControls.json"), 'r') as file:
            data = json.load(file)
    except ValueError:
        data = {}

    return data


def showWindow():
    show_list_ui()

    # showWindow.removeProjectWindow = SimpleWindow()
    # showWindow.removeProjectWindow.show()
    # return showWindow.removeProjectWindow
