import nuke, nukescripts
import os
import json
import compControls.addProjectWindow
import compControls.removeProjectWindow
import re





controlNode = nuke.toNode("Comp_Control")
proj_list = os.path.join(os.path.join(os.path.join(os.path.expanduser("~"), ".nuke"), "vs666", "data"), "compControls.json")


def creation():
    global controlNode
    compControlNode = []
    for node in nuke.allNodes():
        if node.Class() == 'compControl':
            compControlNode.append(node)
    if len(compControlNode) == 0:       
        controlNode = nuke.createNode("compControl")
        controlNode.setName("Comp_Control")
        #nuke.addKnobChanged(compControls.main.refresh, args=(), kwargs={}, nodeClass='compControl', node=None)
        controlNode.knob('knobChanged').setValue('compControls.main.refresh()')
        setDefaults()
        populate()
        
    else:
        nukescripts.clear_selection_recursive()
        compControlNode[0]['selected'].setValue(True)
        nuke.zoomToFitSelected()


def setDefaults():
    controlNode.knob('project_optionMenu').setValues(['Not Set'])
    for knob in ['projectPath_textBox',
                 'projectCode_textBox',
                 'fps_textBox',
                 'gizmoPath_textBox',
                 'scriptsPath_textBox',
                 'shotPath_textBox',
                 'renderPath_textBox']:
        
        controlNode.knob(knob).setEnabled(False)
        controlNode.knob(knob).setValue('Not Set')

def read_json():
    try:
        with open(proj_list, 'r') as file:
            data = json.load(file)
    except ValueError:
        data = {}

    return data

def populate():
    data = read_json()
    menu = ['None',]
    for k in list(data.keys()):
        menu.append(k)
    controlNode.knob('project_optionMenu').setValues(menu)

    
def addProject():
    global selected_folder
    selected_folder = nuke.getFilename("Select project folder", type='directory')
    
    if selected_folder != None:
        ui = compControls.addProjectWindow.showWindow(selected_folder)

def setProject(projectFolder, shot, fps):
    try:
        os.makedirs(projectFolder)
    except:
        print('Project exists already')
    
    
    for folder in ["gizmo", "scripts", "renders", "textures", "matte", "references", "particles", "geo", ]:
        try:
            os.makedirs(os.path.join(projectFolder, folder))
        except:
            pass

    if not shot == "":
        shotFullName = shot + "_v001_" + os.getlogin() + "_start.nk"
        nukescript = os.path.join(projectFolder,shotFullName)
        nuke.scriptSave(nukescript)
        nuke.root().knob("name").setValue(nukescript)
        controlNode.knob("shot_textBox").setValue(shot)
        controlNode.knob("project_optionMenu").setValue(shot)
    populate()
    nuke.root().knob('fps').setValue(int(fps))
        

    return True

    

def refresh():
    try:
        project = controlNode.knob('project_optionMenu').value()
        populate()
        data = read_json()
        try:
            projData = data[project]
            if project == "None":
                setDefaults()
            else:
                controlNode.knob('projectPath_textBox').setValue(os.path.join(projData["path"],project))
                controlNode.knob('projectCode_textBox').setValue("None")
                controlNode.knob('fps_textBox').setValue(projData["FPS"])
                controlNode.knob('gizmoPath_textBox').setValue(os.path.join(projData["path"],project, 'gizmo') )
                controlNode.knob('scriptsPath_textBox').setValue(os.path.join(projData["path"],project, 'scripts'))
                nuke.root().knob('fps').setValue(int(projData["FPS"]))

                
        except Exception as e:
            print('project Not found')
            setDefaults()
            populate()
    except:
        pass


    shot = controlNode.knob('shot_textBox').value()
    if shot == "" or shot == "Not Set":
        controlNode.knob("shotPath_textBox").setValue('Not Set')
        controlNode.knob("renderPath_textBox").setValue('Not Set')
        controlNode.knob('shotDescription_text').setValue('\tNot Set')

    else:
        #shotName = shot.split('_')[0]
        shotName = shot
        currentShotName = nuke.root().knob("name").value().split('\\')[-1].split('/')[-1].split('_')[0]

        if currentShotName == shotName:
            controlNode.knob('shotDescription_text').setValue('\tCurrent Shot')
            pass

        else:
            folder_path = projData['path'] + '/' + project
            files = [f.split('_')[0] for f in os.listdir(folder_path) if os.path.isfile(os.path.join(folder_path, f))]
            shotList = list(set(files))

            if shotName in shotList:
                highVerFile = findHighestVersion(folder_path,shotName)
                controlNode.knob('shotDescription_text').setValue('\tLatest Version : '+highVerFile)
                #nuke.root().knob("name").setValue(os.path.join(folder_path, highVerFile))


            else:
                shotFullName = shotName + "_v001_" + os.getlogin() + "_start.nk"
                nukescript = os.path.join(folder_path,shotFullName)
                controlNode.knob('shotDescription_text').setValue('\tNew Shot : '+shotFullName)

                # nuke.scriptSave(nukescript)
                # nuke.root().knob("name").setValue(nukescript)


                #controlNode.knob("shot_textBox").setValue(shot)
                #controlNode.knob("project_optionMenu").setValue(shot)





def findHighestVersion(folder_path,shotName):
    files_with_versions = []

    # Iterate over files in the folder
    for f in os.listdir(folder_path):
        if shotName in f:
            # Check if it's a file
            if os.path.isfile(os.path.join(folder_path, f)):
                # Split the filename by underscores
                parts = f.split('_')
                
                # Extract the version (assuming it's the second part like v001, v002, ...)
                try:
                    version_str = parts[1]  # version will be like 'v001', 'v002', etc.
                    # Convert version to integer after stripping the 'v' and comparing numerically
                    version = int(version_str[1:])
                    files_with_versions.append((f, version))
                except (IndexError, ValueError):
                    # Skip file if it doesn't match the expected pattern
                    print(f"Skipping {f} due to invalid version format.")

    # Find the file with the highest version
    if files_with_versions:
        highest_version_file = max(files_with_versions, key=lambda x: x[1])[0]
        #print(f"File with highest version: {highest_version_file}")
        return highest_version_file
    else:
        #print("No valid files found.")

        #return highest_version_file
        pass




def removeProject():
    compControls.removeProjectWindow.showWindow()
    refresh()





def loadShot():
    shotToLoad = controlNode.knob('shotDescription_text').value()

    print(shotToLoad)

    if 'Current' in shotToLoad:
        pass

    else:
        if 'Latest' in shotToLoad:
            shotname = shotToLoad.split(': ')[-1]

            data = read_json()
            project = controlNode.knob('project_optionMenu').value()

            nukeScript = data[project]['path'] + project + '/' + shotname
            nuke.scriptClose()
            nuke.scriptOpen(nukeScript)
        elif 'New' in shotToLoad:
            shotname = shotToLoad.split(': ')[-1]
            data = read_json()
            project = controlNode.knob('project_optionMenu').value()

            nukeScript = data[project]['path'] + project + '/' +  shotname

            nuke.scriptClose()
            nuke.root().knob("name").setValue(nukeScript)
            #nuke.root().knob('fps').setValue(data[project]['FPS'])



            

# def setProject():
#     try:
#         with open(proj_list, 'r') as file:
#             data = json.load(file)
#             print(data)
#     except ValueError:
#         data = {}
#         print(data)




def saveNewVersionWithDescription():

    file_path = nuke.root().knob("name").value()

    if file_path == '':
        nuke.scriptSaveAs("")
        return


    description = nuke.getInput('description')

    if description == "":
        description = 'default'

    file_path = nuke.root().knob("name").value()
    folder_path = os.path.dirname(file_path)
    file_name = os.path.basename(file_path)

    version_match = re.search(r'v(\d+)', file_name)

    if version_match:
        # Extract the current version number
        current_version = int(version_match.group(1))
        # Increment the version number
        new_version = current_version + 1
        # Replace the version number in the filename
        file_name = re.sub(r'v(\d+)', f'v{new_version:03d}', file_name)

    name_parts = file_name.rsplit('_', 1)  # Split the file name into two parts at the last underscore
    if len(name_parts) > 1:

        file_name = f"{name_parts[0]}_{description}{os.path.splitext(file_name)[1]}"

    new_file_path = os.path.join(folder_path, file_name)
    nuke.scriptSave(new_file_path)
    nuke.root().knob('name').setValue(new_file_path)
    nuke.scriptSave("")



