from PySide2 import QtWidgets, QtCore
import nuke
import compControls
import os
import json

class SimpleWindow(QtWidgets.QWidget):
    def __init__(self):
        # Set Nuke's main window as the parent
        parent = QtWidgets.QApplication.activeWindow()
        super(SimpleWindow, self).__init__(parent)

        # Set up the window
        self.setWindowTitle("Project Details")
        self.setFixedSize(300, 150)  # Adjusted size to fit all widgets
        # Set the window flags to make it a separate dialog window that stays on top
        self.setWindowFlags(QtCore.Qt.Dialog | QtCore.Qt.WindowStaysOnTopHint)

        # Create the line edits with placeholder text
        self.projectName = QtWidgets.QLineEdit()
        self.projectName.setPlaceholderText("Project Name")

        self.shotName = QtWidgets.QLineEdit()
        self.shotName.setPlaceholderText("Shot")

        self.fps = QtWidgets.QLineEdit()
        self.fps.setPlaceholderText("FPS")

        # Buttons
        buttonsLayout = QtWidgets.QHBoxLayout()
        set_button = QtWidgets.QPushButton("Set")
        cancel_button = QtWidgets.QPushButton("Cancel")

        buttonsLayout.addWidget(set_button)
        buttonsLayout.addWidget(cancel_button)

        # Set up the main layout
        layout = QtWidgets.QVBoxLayout()
        layout.addWidget(self.projectName)
        layout.addWidget(self.shotName)
        layout.addWidget(self.fps)
        layout.addLayout(buttonsLayout)  # Add the QHBoxLayout directly

        self.setLayout(layout)

        # Connect the buttons to their respective functions
        set_button.clicked.connect(self.set_values)
        cancel_button.clicked.connect(self.close)



        nuke_folder = os.path.join(os.path.expanduser("~"), ".nuke")
        self.pluginDataFolder = os.path.join(nuke_folder, "vs666", "data")

    def set_values(self):
        # Store the text from the line edits in variables
        self.project_name_value = self.projectName.text()
        project_code_value = self.shotName.text()
        fps_value = self.fps.text()

        # Print the values (you can store them elsewhere or use them as needed)
        selected_folder = self.folder
        if not os.path.exists(selected_folder):
            nuke.alert("Please choose a valid folder")
            return False
        projectFolder = os.path.join(selected_folder, self.project_name_value)

        self.data = self.read_json()
        projects = list(self.data.keys())

        if os.path.exists(projectFolder):
            if self.project_name_value in projects:
                nuke.alert("Another project exists in the same name")
                return False

        if not fps_value.isdigit():
            nuke.alert("FPS is not valid")
            return False


        

        self.projData = {"FPS" : fps_value,
                        "CODE" : None,
                        "path" : compControls.main.selected_folder
                        }

        self.addProjectData()


        compControls.main.setProject(projectFolder,project_code_value,fps_value, )

        self.close()

    def print_status(self):
        pass

    def addProjectData(self):
        self.data[self.project_name_value] = self.projData
        if self.data:
            with open(os.path.join(self.pluginDataFolder, "compControls.json"), 'w') as file:
                json.dump(self.data, file, sort_keys = True, indent = 4)

 


    def read_json(self):
        try:
            with open(os.path.join(self.pluginDataFolder, "compControls.json"), 'r') as file:
                data = json.load(file)
        except ValueError:
            data = {}

        return data





# Function to show the window
def showWindow(folder):
    showWindow.addProjectWindow = SimpleWindow()
    showWindow.addProjectWindow.show()
    showWindow.addProjectWindow.folder = folder
    return showWindow.addProjectWindow
